//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Runtime.Serialization.Formatters.Soap;
using System.IO;

namespace DelegatesAndEvents
{
	delegate void DelegateCallback();
	[Serializable]
	class A
	{
		public void ACallback()
		{
			Console.WriteLine("A.ACallback()");
		}
		public void BCallback()
		{
			Console.WriteLine("A.BCallback()");
		}
		public void CCallback()
		{
			Console.WriteLine("A.CCallback()");
		}
	}
	class DelegateSerialization
	{
		static void ACallback()
		{
			Console.WriteLine("ACallback()");
		}
		static void Main(string[] args)
		{
			DelegateCallback ad = new DelegateCallback(ACallback);

			Console.WriteLine("{0} {1}", ad.Target, ad.Method);

			Stream streamWrite = File.Create("static-delegate.xml");
			SoapFormatter soapWrite = new SoapFormatter();
			soapWrite.Serialize(streamWrite, ad);
			streamWrite.Close();

			Stream streamRead = File.OpenRead("static-delegate.xml");
			SoapFormatter soapRead = new SoapFormatter();
			DelegateCallback bd = (DelegateCallback)soapRead.Deserialize(streamRead);

			Console.WriteLine("{0} {1}", bd.Target, bd.Method);
			Console.WriteLine("Rwny {0}", ad == bd);
			ad();
			bd();
			streamRead.Close();

			A a = new A();
			ad = new DelegateCallback(a.ACallback);

			Console.WriteLine("{0} {1}", ad.Target, ad.Method);
			streamWrite = File.Create("instance-delegate.xml");
			soapWrite = new SoapFormatter();
			soapWrite.Serialize(streamWrite, ad);
			streamWrite.Close();

			streamRead = File.OpenRead("instance-delegate.xml");
			soapRead = new SoapFormatter();
			bd = (DelegateCallback)soapRead.Deserialize(streamRead);

			Console.WriteLine("{0} {1}", bd.Target, bd.Method);
			Console.WriteLine("Rwny {0}", ad == bd);
			ad();
			bd();
			streamRead.Close();

		}
	}
}
